DROP PROCEDURE [hips].[HealthProviderOrganisationPatientUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Create date: 18 December 2012
-- Description:   Updates an existing record into the HealthProviderOrganisationPatient Table
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderOrganisationPatientUpdate] 
(
	  @HealthProviderOrganisationId INT
	, @PatientMasterId INT
	, @PcehrAdvertised BIT = NULL
	, @AccessCodeRequiredId INT
	, @PcehrDisclosed BIT
	, @UserModified VARCHAR(256)
	, @DateModified datetime
)
AS
BEGIN
    SET NOCOUNT ON
	DECLARE @intErrorCode int

    SET @intErrorCode = 0
    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[HealthProviderOrganisationPatient]
				WHERE [HealthProviderOrganisationId] = @HealthProviderOrganisationId AND [PatientMasterId] = @PatientMasterId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
	IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[HealthProviderOrganisationPatient]
           SET [PcehrAdvertised] = @PcehrAdvertised
             , [AccessCodeRequiredId] = @AccessCodeRequiredId
             , [PcehrDisclosed] = @PcehrDisclosed
             , [DateModified] = GetDate()
             , [UserModified] = @UserModified
         WHERE [PatientMasterId] = @PatientMasterId

        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
		SELECT [HealthProviderOrganisationId]
					 , [PatientMasterId]
					 , [PcehrAdvertised]
					 , [AccessCodeRequiredId]
					 , [PcehrDisclosed]
					 , [DateCreated]
					 , [UserCreated]
					 , [DateModified]
					 , [UserModified]
					 FROM [hips].[HealthProviderOrganisationPatient]            
		WHERE [PatientMasterId] = @PatientMasterId
		AND [HealthProviderOrganisationId] = @HealthProviderOrganisationId
    END

    RETURN(@intErrorCode)

END
GO

